//
//  AppDelegate.m
//  Storing and Synchronizing Dictionaries in iCloud
//
//  Created by Vandad Nahavandipoor on 21/08/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

#import "AppDelegate.h"

@implementation AppDelegate

@synthesize window = _window;

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  NSUbiquitousKeyValueStore *kvoStore = 
    [NSUbiquitousKeyValueStore defaultStore];
  
  NSString *stringValue = @"Mój ciąg tekstowy";
  NSString *stringValueKey = @"MyStringKey";
  
  BOOL boolValue = YES;
  NSString *boolValueKey = @"MyBoolKey";
  
  BOOL mustSynchronize = NO;
  
  if ([[kvoStore stringForKey:stringValueKey] length] == 0){
    NSLog(@"W usłudze iCloud nie można znaleźć wartości ciągu tekstowego. Ustawiam tę wartość...");
    [kvoStore setString:stringValue
                 forKey:stringValueKey];
    mustSynchronize = YES;
  } else {
    NSLog(@"W usłudze iCloud znaleziono wartość ciągu tekstowego. Pobieram tę wartość...");
    stringValue = [kvoStore stringForKey:stringValueKey];
  }
  
  if ([kvoStore boolForKey:boolValueKey] == NO){
    NSLog(@"W usłudze iCloud nie można znaleźć wartości boolowskiej. Ustawiam tę wartość...");
    [kvoStore setBool:boolValue
               forKey:boolValueKey];
    mustSynchronize = YES;
  } else {
    NSLog(@"W usłudze iCloud znaleziono wartość boolowską. Pobieram tę wartość...");
    boolValue = [kvoStore boolForKey:boolValueKey];
  }
  
  if (mustSynchronize){
    if ([kvoStore synchronize]){
      NSLog(@"Udało się przeprowadzić synchronizację z usługą iCloud.");
    } else {
      NSLog(@"Nie udało się przeprowadzić synchronizacji z usługą iCloud.");
    }
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
